/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.input.dbms.service;

import java.lang.invoke.MethodHandles;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.schemaspy.input.dbms.service.ColumnInitializationFailure;
import org.schemaspy.input.dbms.service.InconsistencyException;
import org.schemaspy.input.dbms.service.SqlService;
import org.schemaspy.model.Table;
import org.schemaspy.model.TableColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ColumnService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SqlService sqlService;
    private final Pattern excludeIndirectColumns;
    private final Pattern excludeColumns;

    public ColumnService(SqlService sqlService, Pattern excludeIndirectColumns, Pattern excludeColumns) {
        this.sqlService = sqlService;
        this.excludeIndirectColumns = excludeIndirectColumns;
        this.excludeColumns = excludeColumns;
    }

    public void gatherColumns(Table table) throws SQLException {
        this.initColumns(table);
        if (!table.isView() && !table.isRemote()) {
            this.initColumnAutoUpdate(table, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initColumns(Table table) throws SQLException {
        Class<Table> clazz = Table.class;
        synchronized (Table.class) {
            block12: {
                try (ResultSet rs = this.sqlService.getDatabaseMetaData().getColumns(table.getCatalog(), table.getSchema(), table.getName(), "%");){
                    while (rs.next()) {
                        this.addColumn(table, rs);
                    }
                }
                catch (SQLException exc) {
                    if (table.isLogical()) break block12;
                    throw new ColumnInitializationFailure(table, exc);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void addColumn(Table table, ResultSet rs) throws SQLException {
        String columnName = rs.getString("COLUMN_NAME");
        if (columnName == null) {
            return;
        }
        if (table.getColumn(columnName) == null) {
            TableColumn column = this.initColumn(table, rs);
            table.getColumnsMap().put(column.getName(), (Object)column);
        }
    }

    private TableColumn initColumn(Table table, ResultSet rs) throws SQLException {
        TableColumn column = new TableColumn(table);
        String tmp = rs.getString("COLUMN_NAME");
        column.setName(tmp == null ? null : tmp.intern());
        tmp = rs.getString("TYPE_NAME");
        column.setTypeName(tmp == null ? "unknown" : tmp.intern());
        column.setType(Integer.valueOf(rs.getInt("DATA_TYPE")));
        column.setDecimalDigits(rs.getInt("DECIMAL_DIGITS"));
        Number bufLength = (Number)rs.getObject("BUFFER_LENGTH");
        if (bufLength != null && bufLength.shortValue() > 0) {
            column.setLength((int)bufLength.shortValue());
        } else {
            column.setLength(rs.getInt("COLUMN_SIZE"));
        }
        StringBuilder buf = new StringBuilder();
        buf.append(column.getLength());
        if (column.getDecimalDigits() > 0) {
            buf.append(',');
            buf.append(column.getDecimalDigits());
        }
        column.setDetailedSize(buf.toString());
        column.setNullable(rs.getInt("NULLABLE") == 1);
        column.setDefaultValue((Object)rs.getString("COLUMN_DEF"));
        column.setComments(rs.getString("REMARKS"));
        column.setId((Object)(rs.getInt("ORDINAL_POSITION") - 1));
        column.setAllExcluded(column.matches(this.excludeColumns));
        column.setExcluded(column.isAllExcluded() || column.matches(this.excludeIndirectColumns));
        LOGGER.trace("Excluding column {}.{}: matches {}:{} {}:{}", new Object[]{column.getTable(), column.getName(), this.excludeColumns, column.isAllExcluded(), this.excludeIndirectColumns, column.matches(this.excludeIndirectColumns)});
        return column;
    }

    private void initColumnAutoUpdate(Table table, boolean forceQuotes) {
        StringBuilder sql = new StringBuilder("select * from ");
        String tableName = this.sqlService.getQualifiedTableName(table.getCatalog(), table.getSchema(), table.getName(), forceQuotes);
        sql.append(tableName);
        sql.append(" where 0 = 1");
        try (PreparedStatement stmt = this.sqlService.getDatabaseMetaData().getConnection().prepareStatement(sql.toString());
             ResultSet rs = stmt.executeQuery();){
            ResultSetMetaData rsMeta = rs.getMetaData();
            for (int i = rsMeta.getColumnCount(); i > 0; --i) {
                String columnName = rsMeta.getColumnName(i);
                TableColumn column = ColumnService.getColumn((Table)table, (String)columnName);
                if (Objects.isNull(column)) {
                    throw new InconsistencyException("Column information from DatabaseMetaData differs from ResultSetMetaData, expected to find column named: '" + columnName + "' in columns" + this.listColumns(table) + " of table: " + tableName);
                }
                column.setIsAutoUpdated(rsMeta.isAutoIncrement(i));
            }
        }
        catch (SQLException exc) {
            if (forceQuotes) {
                if (!table.isLogical()) {
                    LOGGER.warn("Failed to determine auto increment status: {}", (Object)exc.getMessage(), (Object)exc);
                    LOGGER.warn("SQL: {}", (Object)sql);
                }
            }
            this.initColumnAutoUpdate(table, true);
        }
    }

    private String listColumns(Table table) {
        return table.getColumns().stream().map(TableColumn::getName).collect(Collectors.joining("','", "['", "']"));
    }

    private static TableColumn getColumn(Table table, String columnName) {
        TableColumn column = table.getColumn(columnName);
        if (Objects.isNull(column)) {
            if (columnName.startsWith(table.getName())) {
                column = table.getColumn(columnName.substring(table.getName().length() + 1));
            } else if (columnName.startsWith(table.getFullName())) {
                column = table.getColumn(columnName.substring(table.getFullName().length() + 1));
            }
        }
        return column;
    }
}

