/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public class Inflection {
    private static final List<Inflection> plural = new ArrayList();
    private static final List<Inflection> singular = new ArrayList();
    private static final List<String> uncountable = new ArrayList();
    private final String pattern;
    private final String replacement;
    private final boolean ignoreCase;

    public Inflection(String pattern) {
        this(pattern, null, true);
    }

    public Inflection(String pattern, String replacement) {
        this(pattern, replacement, true);
    }

    public Inflection(String pattern, String replacement, boolean ignoreCase) {
        this.pattern = pattern;
        this.replacement = replacement;
        this.ignoreCase = ignoreCase;
    }

    private static void plural(String pattern, String replacement) {
        plural.add(0, new Inflection(pattern, replacement));
    }

    private static void singular(String pattern, String replacement) {
        singular.add(0, new Inflection(pattern, replacement));
    }

    private static void irregular(String s, String p) {
        Inflection.plural((String)("(" + s.substring(0, 1) + ")" + s.substring(1) + "$"), (String)("$1" + p.substring(1)));
        Inflection.singular((String)("(" + p.substring(0, 1) + ")" + p.substring(1) + "$"), (String)("$1" + s.substring(1)));
    }

    private static void uncountable(String word) {
        uncountable.add(word);
    }

    public boolean match(String word) {
        int flags = 0;
        if (this.ignoreCase) {
            flags |= 2;
        }
        return Pattern.compile(this.pattern, flags).matcher(word).find();
    }

    public String replace(String word) {
        int flags = 0;
        if (this.ignoreCase) {
            flags |= 2;
        }
        return Pattern.compile(this.pattern, flags).matcher(word).replaceAll(this.replacement);
    }

    public static String pluralize(String word) {
        if (Inflection.isUncountable((String)word)) {
            return word;
        }
        for (Inflection inflection : plural) {
            if (!inflection.match(word)) continue;
            return inflection.replace(word);
        }
        return word;
    }

    public static String singularize(String word) {
        if (Inflection.isUncountable((String)word)) {
            return word;
        }
        for (Inflection inflection : singular) {
            if (!inflection.match(word)) continue;
            return inflection.replace(word);
        }
        return word;
    }

    public static boolean isUncountable(String word) {
        for (String w : uncountable) {
            if (!w.equalsIgnoreCase(word)) continue;
            return true;
        }
        return false;
    }

    static {
        Inflection.plural((String)"$", (String)"s");
        Inflection.plural((String)"s$", (String)"s");
        Inflection.plural((String)"(ax|test)is$", (String)"$1es");
        Inflection.plural((String)"(octop|vir)us$", (String)"$1i");
        Inflection.plural((String)"(alias|status)$", (String)"$1es");
        Inflection.plural((String)"(bu)s$", (String)"$1ses");
        Inflection.plural((String)"(buffal|tomat)o$", (String)"$1oes");
        Inflection.plural((String)"([ti])um$", (String)"$1a");
        Inflection.plural((String)"sis$", (String)"ses");
        Inflection.plural((String)"(?:([^f])fe|([lr])f)$", (String)"$1$2ves");
        Inflection.plural((String)"(hive)$", (String)"$1s");
        Inflection.plural((String)"([^aeiouy]|qu)y$", (String)"$1ies");
        Inflection.plural((String)"(x|ch|ss|sh)$", (String)"$1es");
        Inflection.plural((String)"(matr|vert|ind)ix|ex$", (String)"$1ices");
        Inflection.plural((String)"([m|l])ouse$", (String)"$1ice");
        Inflection.plural((String)"^(ox)$", (String)"$1en");
        Inflection.plural((String)"(quiz)$", (String)"$1zes");
        Inflection.singular((String)"s$", (String)"");
        Inflection.singular((String)"(n)ews$", (String)"$1ews");
        Inflection.singular((String)"([ti])a$", (String)"$1um");
        Inflection.singular((String)"((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)ses$", (String)"$1$2sis");
        Inflection.singular((String)"(^analy)ses$", (String)"$1sis");
        Inflection.singular((String)"([^f])ves$", (String)"$1fe");
        Inflection.singular((String)"(hive)s$", (String)"$1");
        Inflection.singular((String)"(tive)s$", (String)"$1");
        Inflection.singular((String)"([lr])ves$", (String)"$1f");
        Inflection.singular((String)"([^aeiouy]|qu)ies$", (String)"$1y");
        Inflection.singular((String)"(s)eries$", (String)"$1eries");
        Inflection.singular((String)"(m)ovies$", (String)"$1ovie");
        Inflection.singular((String)"(x|ch|ss|sh)es$", (String)"$1");
        Inflection.singular((String)"([m|l])ice$", (String)"$1ouse");
        Inflection.singular((String)"(bus)es$", (String)"$1");
        Inflection.singular((String)"(o)es$", (String)"$1");
        Inflection.singular((String)"(shoe)s$", (String)"$1");
        Inflection.singular((String)"(cris|ax|test)es$", (String)"$1is");
        Inflection.singular((String)"(octop|vir)i$", (String)"$1us");
        Inflection.singular((String)"(alias|status)es$", (String)"$1");
        Inflection.singular((String)"^(ox)en", (String)"$1");
        Inflection.singular((String)"(vert|ind)ices$", (String)"$1ex");
        Inflection.singular((String)"(matr)ices$", (String)"$1ix");
        Inflection.singular((String)"(quiz)zes$", (String)"$1");
        Inflection.irregular((String)"person", (String)"people");
        Inflection.irregular((String)"man", (String)"men");
        Inflection.irregular((String)"child", (String)"children");
        Inflection.irregular((String)"sex", (String)"sexes");
        Inflection.irregular((String)"move", (String)"moves");
        Inflection.uncountable((String)"equipment");
        Inflection.uncountable((String)"information");
        Inflection.uncountable((String)"rice");
        Inflection.uncountable((String)"money");
        Inflection.uncountable((String)"species");
        Inflection.uncountable((String)"series");
        Inflection.uncountable((String)"fish");
        Inflection.uncountable((String)"sheep");
    }
}

