/*
 * Decompiled with CFR 0.152.
 */
package org.schemaspy.validator;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.schemaspy.validator.DatabasetypeValidator;
import org.schemaspy.validator.ExclusionValidator;
import org.schemaspy.validator.InclusionValidator;

public class NameValidator {
    private final String clazz;
    private final Pattern include;
    private final Pattern exclude;
    private final Set<String> validTypes;

    public NameValidator(String clazz, Pattern include, Pattern exclude, String[] validTypes) {
        this.clazz = clazz;
        this.include = include;
        this.exclude = exclude;
        this.validTypes = new HashSet();
        for (String type : validTypes) {
            this.validTypes.add(type.toUpperCase());
        }
    }

    public boolean isValid(String name, String type) {
        return new DatabasetypeValidator(this.validTypes).isValid(type) && new ExclusionValidator(this.clazz, this.exclude).isValid(name) && new InclusionValidator(this.clazz, this.include).isIncluded(name);
    }
}

